import java.awt.*;



public class SouthPanel extends Panel {


  MainWindow mW;

  int ty;
  

  Label actualBrowserLabel;
  Label clientLabel;
  Label serverLabel;

  Panel subPanel; 
  HistoryPanel historyPanel;
  Scrollbar scrollbar;





  public SouthPanel(MainWindow mainWindow) { 


    mW = mainWindow;

    setLayout(null);

    actualBrowserLabel = new Label("Actual Browser Display", Label. CENTER);
    actualBrowserLabel. setFont( new Font("Helvetica", Font. BOLD, 18) );
    clientLabel = new Label("Client", Label. CENTER);
    clientLabel.  setFont( new Font("Helvetica", Font. BOLD, 18) );
    serverLabel = new Label("  Server", Label. CENTER);
    serverLabel.  setFont( new Font("Helvetica", Font. BOLD, 18) );

    add(actualBrowserLabel);
    add(clientLabel);
    add(serverLabel);

    subPanel = new Panel();
    subPanel. setLayout( new BorderLayout() );
    historyPanel = new HistoryPanel(mainWindow);
    scrollbar = new Scrollbar(Scrollbar.VERTICAL);
    subPanel. add("Center", historyPanel);
    subPanel. add("East", scrollbar);
    add(subPanel);


    validate();

    resizeVertical();
  }




  public void paint(Graphics g) {


    // Rahmen zeichnen
    g. setColor(getBackground());
    g. draw3DRect(0, 0, size(). width - 1, size(). height - 1, true);
    g. draw3DRect(5, 5, size(). width - 11, size(). height - 11 , false);


    // Fonts
    Font labelFont = new Font("Helvetica", Font. BOLD, 17);

    if ( size(). width < 600) {
	
      labelFont = new Font( "Helvetica", Font. BOLD, 16);
      actualBrowserLabel. setFont( labelFont );
      clientLabel.  setFont( labelFont );
      serverLabel.  setFont( labelFont );
    }
    
    if ( 600 <= size().width & size(). width < 800) {
      
      labelFont = new Font( "Helvetica", Font. BOLD, 17);
      actualBrowserLabel. setFont( labelFont );
      clientLabel.  setFont( labelFont );
      serverLabel.  setFont( labelFont );
    }
    
    if ( 800 <= size().width & size(). width < 1000) {
      
      labelFont = new Font( "Helvetica", Font. BOLD, 20);
      actualBrowserLabel. setFont( labelFont );
      clientLabel.  setFont( labelFont );
      serverLabel.  setFont( labelFont );
    }

    if ( size(). width >= 1000) {
      
      labelFont = new Font( "Helvetica", Font. BOLD, 25);
      actualBrowserLabel. setFont( labelFont );
      clientLabel.  setFont( labelFont );
      serverLabel.  setFont( labelFont );
    }
      


    // Labels aktualisieren
    int actualBrowserLabelWidth = 
      ( size(). width - scrollbar. size(). width - 20 ) * 1/2;

    int labelsHeight = 30;


    actualBrowserLabel. reshape( 10, 10, 
				 actualBrowserLabelWidth, labelsHeight );

    clientLabel. reshape( actualBrowserLabelWidth + 10, 10,
			  actualBrowserLabelWidth * 1/2, labelsHeight);    

    serverLabel. reshape( actualBrowserLabelWidth * 3/2 + 10, 10,
			  actualBrowserLabelWidth * 1/2, labelsHeight);    


    subPanel. reshape(10,
		      10 + labelsHeight, 
		      size(). width - 21,
		      size(). height - labelsHeight - 21 );




    subPanel. validate();

    scrollbar. setLineIncrement(20);
    resizeVertical(); //  Falls Fenster vergroessert wurde
    return;
  }
   

  //Don't call this until the historyPanel size is valid.
  void resizeVertical() {
  
    int historyPanelHeight = historyPanel.size().height;


    scrollbar.setValues( //draw starting at this y:
				 historyPanel.ty, 
				 
				 //visible arg--amount to scroll for a "page":
				 (int)(historyPanelHeight * 0.9), 

				 //minimum image y to specify:
				 0,
				 
				 //maximum image y to specify:
				 1500);

    //"visible" arg to setValues() has no effect after scrollbar is visible.
    scrollbar. setPageIncrement((int)(historyPanelHeight * 0.9));
    return;
  }




  public boolean handleEvent(Event e) {

    switch (e.id) {

    case Event.SCROLL_LINE_UP:
    case Event.SCROLL_LINE_DOWN:
    case Event.SCROLL_PAGE_UP:
    case Event.SCROLL_PAGE_DOWN:
    case Event.SCROLL_ABSOLUTE:
	
      historyPanel. ty = ((Integer)e.arg).intValue();
      historyPanel. repaint();
      repaint();
    }

    return true;//super. handleEvent(e);

  }



}




